"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.scanHelper = scanHelper;

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function pattern(str) {
  var string = str.replace(/([+{($^|.\\])/g, '\\$1');
  string = string.replace(/(^|[^\\])([*?])/g, '$1.$2');
  string = "^".concat(string, "$");
  var p = new RegExp(string);
  return p.test.bind(p);
}

function getCountAndMatch(args) {
  if (args.length > 4) {
    throw new Error('Too many arguments');
  }

  if (args.length % 2 !== 0) {
    throw new Error('Args should be provided by pair (name & value)');
  }

  var count = 10;
  var matchPattern = null;
  var test = "".concat(args[0]).concat(args[2]).toUpperCase();

  if (test === 'UNDEFINEDUNDEFINED') {
    return [count, matchPattern];
  }

  if (test === 'MATCHUNDEFINED') {
    matchPattern = pattern(args[1]);
  } else if (test === 'COUNTUNDEFINED') {
    count = parseInt(args[1], 10);
  } else if (test === 'MATCHCOUNT') {
    matchPattern = pattern(args[1]);
    count = parseInt(args[3], 10);
  } else if (test.startsWith('MATCH') || test.startsWith('COUNT')) {
    throw new Error('BAD Syntax');
  } else {
    throw new Error("Uknown option ".concat(args[0]));
  }

  if (Number.isNaN(count)) {
    throw new Error('count must be integer');
  }

  return [count, matchPattern];
}

function scanHelper(allKeys, size, cursorStart) {
  var cursor = parseInt(cursorStart, 10);

  if (Number.isNaN(cursor)) {
    throw new Error('Cursor must be integer');
  }

  for (var _len = arguments.length, args = new Array(_len > 3 ? _len - 3 : 0), _key = 3; _key < _len; _key++) {
    args[_key - 3] = arguments[_key];
  }

  var _getCountAndMatch = getCountAndMatch(args),
      _getCountAndMatch2 = _slicedToArray(_getCountAndMatch, 2),
      count = _getCountAndMatch2[0],
      matchPattern = _getCountAndMatch2[1];

  var nextCursor = cursor + count;
  var keys = allKeys.slice(cursor, nextCursor); // Apply MATCH filtering _after_ getting number of keys

  if (matchPattern) {
    var i = 0;

    while (i < keys.length) {
      if (!matchPattern(keys[i])) {
        keys.splice(i, size);
      } else {
        i += size;
      }
    }
  } // Return 0 when iteration is complete.


  if (nextCursor >= allKeys.length) {
    nextCursor = 0;
  }

  return [String(nextCursor), keys];
}