"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSubscribedChannels = getSubscribedChannels;
exports.subscribeToChannel = subscribeToChannel;
exports.unsubscribeFromChannel = unsubscribeFromChannel;

var _emitMessage = _interopRequireDefault(require("./emitMessage"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function getSubscribedChannels(instance, channelStore) {
  var subscribedChannels = [];

  if (!channelStore.instanceListeners) {
    return [];
  }

  channelStore.instanceListeners.forEach(function (instanceMap, channel) {
    if (instanceMap.has(instance)) {
      subscribedChannels.push(channel);
    }
  });
  return subscribedChannels;
}

function subscribeToChannel(instance, chan, channels, isPattern) {
  if (!channels.instanceListeners.has(chan)) {
    channels.instanceListeners.set(chan, new Map());
  }

  if (channels.instanceListeners.get(chan).has(instance)) {
    // do not register another listener for existing channel
    return;
  } // Pattern events include the channel, regular events do not, so we pass chan in directly


  var listener = function listener(message, channel) {
    return (0, _emitMessage.default)(instance, isPattern ? channel : chan, message);
  };

  channels.on(chan, listener);
  channels.instanceListeners.get(chan).set(instance, listener);
}

function unsubscribeFromChannel(instance, chan, channels) {
  if (!channels.instanceListeners || channels.instanceListeners.has(chan) === false) {
    // there are no subscriptions to this channel
    return;
  }

  var channelMap = channels.instanceListeners.get(chan);

  if (channelMap.has(instance) === false) {
    // this instance is not subscribed to the channel
    return;
  }

  var listener = channelMap.get(instance);
  channels.removeListener(chan, listener);
  channelMap.delete(instance);

  if (channelMap.size === 0) {
    // tidy up: remove the map if it's empty
    channels.instanceListeners.delete(chan);
  }
}