"use strict";

const { luastring_of } = require('./defs.js');

const luai_ctype_ = luastring_of(
    0x00,  /* EOZ */
    0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,        /* 0. */
    0x00,  0x08,  0x08,  0x08,  0x08,  0x08,  0x00,  0x00,
    0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,        /* 1. */
    0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
    0x0c,  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,        /* 2. */
    0x04,  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,
    0x16,  0x16,  0x16,  0x16,  0x16,  0x16,  0x16,  0x16,        /* 3. */
    0x16,  0x16,  0x04,  0x04,  0x04,  0x04,  0x04,  0x04,
    0x04,  0x15,  0x15,  0x15,  0x15,  0x15,  0x15,  0x05,        /* 4. */
    0x05,  0x05,  0x05,  0x05,  0x05,  0x05,  0x05,  0x05,
    0x05,  0x05,  0x05,  0x05,  0x05,  0x05,  0x05,  0x05,        /* 5. */
    0x05,  0x05,  0x05,  0x04,  0x04,  0x04,  0x04,  0x05,
    0x04,  0x15,  0x15,  0x15,  0x15,  0x15,  0x15,  0x05,        /* 6. */
    0x05,  0x05,  0x05,  0x05,  0x05,  0x05,  0x05,  0x05,
    0x05,  0x05,  0x05,  0x05,  0x05,  0x05,  0x05,  0x05,        /* 7. */
    0x05,  0x05,  0x05,  0x04,  0x04,  0x04,  0x04,  0x00,
    0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,        /* 8. */
    0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
    0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,        /* 9. */
    0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
    0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,        /* a. */
    0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
    0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,        /* b. */
    0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
    0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,        /* c. */
    0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
    0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,        /* d. */
    0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
    0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,        /* e. */
    0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
    0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,        /* f. */
    0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00
);

const ALPHABIT = 0;
const DIGITBIT = 1;
const PRINTBIT = 2;
const SPACEBIT = 3;
const XDIGITBIT = 4;

const lisdigit = function(c) {
    return (luai_ctype_[c+1] & (1<<DIGITBIT)) !== 0;
};

const lisxdigit = function(c) {
    return (luai_ctype_[c+1] & (1<<XDIGITBIT)) !== 0;
};

const lisprint = function(c) {
    return (luai_ctype_[c+1] & (1<<PRINTBIT)) !== 0;
};

const lisspace = function(c) {
    return (luai_ctype_[c+1] & (1<<SPACEBIT)) !== 0;
};

const lislalpha = function(c) {
    return (luai_ctype_[c+1] & (1<<ALPHABIT)) !== 0;
};

const lislalnum = function(c) {
    return (luai_ctype_[c+1] & ((1<<ALPHABIT)|(1<<DIGITBIT))) !== 0;
};

module.exports.lisdigit   = lisdigit;
module.exports.lislalnum  = lislalnum;
module.exports.lislalpha  = lislalpha;
module.exports.lisprint   = lisprint;
module.exports.lisspace   = lisspace;
module.exports.lisxdigit  = lisxdigit;
