const jwt = require('jsonwebtoken');
module.exports = {
    name: 'jwt-auth',
    schema: { // This is for Admin API to validate params
      $id: "http://express-gateway.io/schemas/plugin-configure-example.json",
    },
    policy: (actionParams) => {
      return (req, res, next) => {
        let token = req.headers['authorization'];
        if (!token) {
          return res.status(401).json({
            message: 'No token provided.'
          });
        }
        token = token.replace('Bearer ', '');
        jwt.verify(token, process.env.JWT_SECRET, (err, decoded) => {
          if (err) {
            return res.status(401).json({
              message: 'Token is not valid.'
            });
          }          
          req.user = decoded;
          next();
        });
      }
    }
  }