const { off } = require("process");
const https = require('https');
var async      = require('async');
require("dotenv").config({ path: "../.env" });
const connect_pool = require("./config/database");

module.exports = {

  add_log: (request, response) => {
    var req = JSON.stringify(request);
    
    try {
      connect_pool.query(
        `INSERT into tbl_dealer_error_log(request,response)
        VALUES(?,?)`,
        [req,response]
      );
    } catch (e) {}

  },
  get_bundle_types: (callBack) => {
    let type = "BUNDLE_TYPE";

    try {
      connect_pool.query(
        `select name,value from tbl_dropdown WHERE type = ? GROUP BY name`,
        [type],
        (err, result) => {

          if (err) {
            return callBack(err);
          }

          if (result.length == 0) {
            return callBack(1);
          }

          result_array = [];

          result.forEach((element) => {
            var res = {
              "bundle_type" : element.name,
              "brand" : element.value
            }
            result_array.push(res);
          });

          if (result.length == result_array.length) {
            return callBack(null, result_array);
          }
        }
      );
    } catch (e) {
      return callBack(e);
    }
  },
  get_devices_by_stocktype: (body_data, callBack) => {

    var devices_list = [];
    var vendor_id = body_data.vendor_id;
    let saletype = "DEALERAPP";
    let status = "RFS";
    let stock_type = body_data.stock_type;
    
    if(stock_type == "OPEN BOX"){
      var catArr = ["OPEN BOX","DEMO"];
    } else if(stock_type == "PREXO"){
      var catArr = ["PREXO"];
    }
    // console.log(catArr)
    try {
      connect_pool.query(
        `select grnreport_id, nhdin as device_id, product_brand, device_name, nhmod, color,ram,rom,SKU,stock_type, device_sub_category, SUBSTRING(SKU, 1, LENGTH(SKU)-4) as SKU, mrp, stock_type, certification_grade from tbl_grnreport 
        WHERE saletype = ? AND status = ? AND stock_type IN ?`,
        [ saletype, status, [catArr] ],
        (err_msg, result) => {

          if (err_msg) {
            return callBack(1, err_msg);
          }

          if (result.length == 0) {
            var err_msg = "No results found";
            return callBack(null, devices_list);
          }
          id_list = [];
          if (result.length > 0) {

            for (var y = 0; y < result.length; y++) {
              var grnreport_id = result[y].grnreport_id;
              id_list.push(grnreport_id);
            }

          }
          
          result.forEach((value) => {
            var grnreport_id = value.grnreport_id;
            var status_arr = ["FINANCE_PENDING","FINANCE_APPROVED","DRAFT","FINANCE_REJECTED","WAREHOUSE_REJECTED"];

            try {
              connect_pool.query(
                `SELECT status,device_name FROM DEALER_SALESORDER_EXPORT_VIEW WHERE grnreport_id = ? ORDER BY salesorder_id DESC`,
                [grnreport_id],
                (check_err, check_data) => {

                  if (check_err) {
                    return callBack(1, check_err);
                  }
                  
                  if (check_data.length > 0) {
                    var status = check_data[0].status;
                  } else {
                    var status = "TESTING";
                  }
                  
                  if (status_arr.includes(status)) {
                    var index = id_list.indexOf(grnreport_id);

                    if (index >= 0) {
                      id_list.splice( index, 1 );
                    }
                    if(id_list.length == devices_list.length){
                      return callBack(null, devices_list)
                    }
                  }

                  if (!status_arr.includes(status)) {
                    
                    try {
                      connect_pool.query(
                        `select * from tbl_dealer_cart WHERE bundle_id = ? AND vendor_id = ?`,
                        [grnreport_id, vendor_id],
                        (cart_err, cart_response) => {

                          if (cart_err) {
                            return callBack(cart_err);
                          }

                          if (cart_response.length < 1) {
                            var flag = 0;
                          } else {
                            var flag = 1;
                          }
                          
                          
                          var server_path = process.env.IMAGE_URL;
                          var image_name = value.nhmod + '.jpg';
                          var actual_image_url = server_path + image_name;
                          var default_image_url = server_path + "default.jpg";
                          var image_path = ''
                          https.get(actual_image_url,function(res){
                            if(res.statusCode == 200){
                              image_path = actual_image_url;
                            } else {
                              image_path = default_image_url;
                            }
                            result_obj = {
                              grnreport_id: grnreport_id,
                              device_id: value.device_id,
                              product_brand: value.product_brand,
                              device_name: value.device_name,
                              color: value.color,
                              ram: value.ram,
                              rom: value.rom,
                              sku: value.SKU,
                              device_sub_category: value.device_sub_category,
                              mrp: value.mrp,
                              certification_grade: value.certification_grade,
                              image_path : image_path,
                            };
                            result_obj.flag = flag;
                            devices_list.push(result_obj);
                            if (devices_list.length == id_list.length) {
                              id_list.length = 0;
                              return callBack(null, devices_list);
                            }
                          });
                        }
                      );
                    } catch (e) {
                      return callBack(e);
                    }
                  }
                  // else{
                  //   return callBack(null,{})
                  // }
                }
              );
            } catch (e) {
              return callBack(e);
            }
          });
        }
      );
    } catch (e) {
      return callBack(e);
    }
  },
  getBundles_data : (req_data, callBack) =>  {
    
    async.parallel([
      function(cb) {
        connect_pool.query('SELECT attached_to_vendor FROM tbl_dealer_role_hierarchy Where vendor_id = ? AND active = ?', req_data.vendor_id,"Y", function (err, rows1) {
              if (err) {
                  return cb(err,null);
              }
              console.log(rows1)
              return cb(null, rows1);
          });
      },
      function(cb) {
        connect_pool.query('SELECT * FROM SS_BUNDLE_AVAILABLE_LIST_VIEW Where vendor_id = ?', 10181, function (err, rows2) {
              if (err) {
                  return cb(err,null);
              }
              return cb(null, rows2);
          });
      }
    ], function(error, callbackResults) {
      
      if (error) {
          //handle error
          return cb(error);
      } else {
          console.log(callbackResults[0]); // rows1
          console.log(callbackResults[1]); // rows2
          // use this data to send back to client etc.
      }
    });
  },
  get_bundles: async (vendor_id, callBack) => {
    let qr1 = "select attached_to_vendor, attached_vendor_cat, active from ATTACHED_VENDOR_CATEGORY_LIST_VIEW where vendor_id = ?";
    var qr1_res = await new Promise((res, rej) => {
      connect_pool.query(qr1, [vendor_id], (row1_err, row1) => {
            if (row1_err) return callBack(row1_err);
            res(row1);
        });
    });
    if(qr1_res.length > 0){

      if(qr1_res[0].active == "N"){

        if(qr1_res[0].attached_vendor_cat == 2){

          var res_obj = {
            "status" : 0,
            "message": "Your Super Stockiest is not in Active. Please contacct your super stockiest or Sloyd"
          }
        } else if(qr1_res[0].attached_vendor_cat == 3){

          var res_obj = {
            "status" : 0,
            "message": "Your Distributor is not in Active. Please contacct your distributor or Sloyd"
          }
        }
        return callBack(res_obj)
      } else if(qr1_res[0].active == "Y"){

        if(qr1_res[0].attached_vendor_cat == 1){
          
          var status = "ACTIVE";
          var qr2 = "select bundle_id, bundle_no, type, quantity,amount, mop, category, sub_category, status from tbl_dealer_bundle WHERE status = ?";
        } else{

          let attached_vendor_id = qr1_res[0].attached_to_vendor;
          var status = attached_vendor_id;
          var qr2 = "select bundle_id, bundle_no, type, quantity,amount, mop, category, sub_category, bundle_status from SS_BUNDLES_PRICE_LIST_VIEW WHERE vendor_id = ?"; 
        }
    }
  }
  else{
      var status = "ACTIVE";
      var qr2 = "select bundle_id, bundle_no, type, quantity,amount, mop, category, sub_category, status from tbl_dealer_bundle WHERE status = ?"; 
  }
  
  try{
    var qr2_res = await new Promise((res, rej) => {
      connect_pool.query(qr2, [status],
        (result1_err, results_1) => {
          
            if (result1_err){
              //connection.rollback();
              return callBack(result1_err);
            }
            if (results_1.length == 0) {
              //connection.rollback();
              return callBack(1);
            }
            res(results_1);
        });
      });
      
      var bundle_ids = [];
      var devices_list = [];
      for (var j = 0; j < qr2_res.length; j += 1) {
        var bundle_id = qr2_res[j].bundle_id;
        bundle_ids.push(bundle_id);
        var bundle_type = qr2_res[j].type;
        var grade_qnty = "";

        if (bundle_type == "1A") {
          grade_qnty = "SG-A(5) SG-B(5)";
        } else if (bundle_type == "1B") {
          grade_qnty = "SG-A(4) SG-B(6)";
        } else if (bundle_type == "1C") {
          grade_qnty = "SG-A(2) SG-B(3) SG-C(5)";
        } else if (bundle_type == "1D") {
          grade_qnty = "SG-D(10)";
        } else if (bundle_type == "1E") {
          grade_qnty = "SG-B(3) SG-C(7)";
        } else if (bundle_type == "1F") {
          grade_qnty = "SG-B(3) SG-C(5) SG-D(2)";
        } else if (bundle_type == "2A" || bundle_type == "2B" || bundle_type == "2C" || bundle_type == "2D" ||
          bundle_type == "2E" || bundle_type == "2F") {
          grade_qnty = "SG-A(3) SG-B(3) SG-B(4)";
        }
        var qr3 = "select grade, count(item_id) as grade_qnty from tbl_dealer_bundle_item WHERE bundle_id = ? GROUP BY grade";
        var qr3_res = await new Promise((res, rej) => {
          connect_pool.query(qr3, [bundle_id], 
            (result3_err, results_3) => {
              
                if (result3_err){
                  //connection.rollback();
                  return callBack(result3_err);
                } 
                res(results_3);
            });
        });
        
        if (qr3_res.length < 1) {
          return callBack(1);
        }
        var summary_grade = [];
        for(var k = 0; k < qr3_res.length; k += 1){
          
          summary_grade.push(qr3_res[k].grade + " - " + qr3_res[k].grade_qnty);
        }
        var diff = qr2_res[j].mop - qr2_res[j].amount;
        var mop = qr2_res[j].mop;
        save_percent = parseInt((diff * 100) / mop);
        let string = summary_grade.toString();
        var qr4 = `select * from tbl_dealer_cart WHERE bundle_id = ? AND vendor_id = ?`;
        
        var qr4_res = await new Promise((res, rej) => {
          connect_pool.query(qr4, [bundle_id, vendor_id], 
            (result4_err, results_4) => {
                if (result4_err){
                  //connection.rollback(); 
                  return callBack(result4_err);
                } 
                res(results_4);
            });
        });
        
        if (qr4_res.length < 1) {
          var flag = 0;
        } else {
          var flag = 1;
        }
        var qr5 = "select * from DEALER_ORDERED_BUNDLE_LIST_VIEW WHERE bundle_id = ? AND vendor_id = ? AND status != ?";
        var qr5_res = await new Promise((res, rej) => {
          connect_pool.query(qr5, [bundle_id, vendor_id,"CANCELLED"], 
            (result5_err, results_5) => {
              
                if (result5_err){
                  //connection.rollback(); 
                  return callBack(result5_err);
                } 
                res(results_5);
            });
        });
        
        if (qr5_res.length < 1) {
          var result_obj = {
            bundle_id: bundle_id,
            bundle_no: qr2_res[j].bundle_no,
            type: qr2_res[j].type,
            grade_qnty: grade_qnty,
            quantity: qr2_res[j].quantity,
            mop: qr2_res[j].mop,
            amount: qr2_res[j].amount,
            save: save_percent,
            category: qr2_res[j].category,
            sub_category: qr2_res[j].sub_category,
            status: qr2_res[j].status,
            grade_summary: string,
          };
          result_obj.flag = flag;
          devices_list.push(result_obj);

          if (bundle_ids.length == qr2_res.length) {
            return callBack(null, devices_list);
          }
        }  else{
            
          if (bundle_ids.length == qr2_res.length) {
      
              return callBack("No bundles available");
          }
        }
      }
  } catch(err){
    return callBack(err)
  }
},
  bundle_info: async (body, callBack) => {

    let vendor_id = body.vendor_id;
    let bundle_id = body.bundle_id;
    let attached_vendor_id = body.attached_vendor_id;
    let qr1 = "select order_id from DEALER_ORDERED_BUNDLE_LIST_VIEW WHERE vendor_id = ? AND bundle_id";
    var qr1_res = await new Promise((res, rej) => {
      connect_pool.query(qr1, [attached_vendor_id,bundle_id], (row1_err, row1) => {
            if (row1_err) return callBack(row1_err);
            res(row1);
        });
    });
    var order_item_id = '';
    if(qr1_res.length > 0){
      
      order_item_id = qr1_res[0].order_item_id;
    }
    try {
      connect_pool.query(
        `select * from tbl_dealer_bundle_item WHERE bundle_id = ?`,
        [bundle_id],
        (err, result) => {
          
          if (err) {
            return callBack(err);
          }

          if (result.length == 0) {
            return callBack(1);
          }

          var bundle_data = [];

          result.forEach((element) => {
            let grnreport_id = element.grnreport_id;
            let qr2 = "select sale_price from tbl_dealerapp_order_bundle_item WHERE order_item_id = ? AND grnreport_id";
            var qr2_res = new Promise((res, rej) => {
              connect_pool.query(qr2, [order_item_id, grnreport_id], (row2_err, row2) => {
                    if (row2_err) return callBack(row2_err);
                    res(row2);
                });
            });
            if(qr2_res.length > 0){
                var price = qr2_res[0].sale_price;
            } else{
              var price = element.price;
            }
            try {
              connect_pool.query(
                `SELECT product_brand, nhmod, device_name, SKU, color, ram, rom, stock_type, device_sub_category from tbl_grnreport WHERE grnreport_id = ?`,
                [grnreport_id],
                (err, row) => {

                  if (err) {
                   
                    return callBack(err);
                  }

                  if (row.length < 1) {
                    return callBack(err);
                  }
                  var server_path = process.env.IMAGE_URL;
                  var image_name = element.nhmod + '.jpg';
                  var actual_image_url = server_path + image_name;
                  var default_image_url = server_path + "default.jpg";
                  var image_path = ''
                  https.get(actual_image_url,function(res){
                    if(res.statusCode == 200){
                      image_path = actual_image_url;
                    } else {
                      image_path = default_image_url;
                    }
                    result_obj = {
                      product_brand: row[0].product_brand,
                      device_name: row[0].device_name,
                      sku: row[0].SKU,
                      ram: row[0].ram,
                      rom: row[0].rom,
                      color: row[0].color,
                      category: row[0].stock_type,
                      sub_categoty: row[0].device_sub_categoty,
                      grade: element.grade,
                      mop: element.mop,
                      // price: element.price,
                      price: price,
                      image_path: image_path,
                      remark: element.remark
                    };
  
                    bundle_data.push(result_obj);
                    
                    if (bundle_data.length == result.length) {
                      return callBack(null, bundle_data);
                    }
                  })
                }
              );
            } catch (e) {
              return callBack(e);
            }

          });
        }
      );
    } catch (e) {
      return callBack(e);
    }

  }
};
