var async = require("async");
require("dotenv").config({ path: "../.env" });

const {
  add_log,
  get_devices_by_stocktype,
  get_bundles,
  getBundles_data,
  get_bundle_types,
  bundle_info,
} = require("./devices-service");
module.exports = {
  getDevicesByStockType: (req, res) => {
    var body_data = req.body;
    var stock_type = body_data.stock_type;

    var oldSend = res.send;

    res.send = function(response){
      add_log(body_data, response)
      oldSend.apply(res, arguments);
    }

    if (stock_type == "") {
      return res.status(200).json({
        status: 0,
        message: "Please Send Stock Type",
      });
    }

    try {
      get_devices_by_stocktype(body_data, (err, results) => {

        if (err) {

          if (err == 1) {
            return res.status(404).json({
              status: 0,
              message: results,
            });
          }
          return res.status(500).json({
            status: 0,
            err: err,
          });
        }
        return res.status(200).json({
          status: 1,
          data: results,
        });
      });
    } catch (error) {
      return res.status(500).json({
        status: 0,
        err: error,
      });
    }
  },
  getBundles: (req, res) => {
    var vendor_id = req.params.vendor_id;
    var oldSend = res.send;

    res.send = function(response){
      add_log(vendor_id, response)
      oldSend.apply(res, arguments);
    }
    if (vendor_id == "" || vendor_id == 0 || vendor_id == undefined || vendor_id == "NaN") {
      return res.status(200).json({
        status: 0,
        message: "Please provide valid vendor id",
      });
    }
    try {
      get_bundles(vendor_id, (err, results) => {
        if (err) {

          if (err == 1) {
            return res.status(404).json({
              status: 0,
              message: "No results found",
            });
          }
          return res.status(500).json({
            status: 0,
            err: err,
          });
        }
        return res.status(200).json({
          status: 1,
          data: results,
        });
      });
    } catch (error) {
      console.log(error)
      return res.status(500).json({
        status: 0,
        err: error,
      });
    }
  },
  bundleInfo: (req, res) => {
    var body = req.body;
    var oldSend = res.send;

    res.send = function(response){
      add_log(body, response)
      oldSend.apply(res, arguments);
    }

    try {
      bundle_info(body, (err, results) => {

        if (err) {

          if (err == 1) {
            return res.status(404).json({
              status: 0,
              message: "No results found",
            });
          }
          return res.status(500).json({
            status: 0,
            err: err,
          });
        }
        return res.status(200).json({
          status: 1,
          data: results,
        });
      });
    } catch (error) {
      return res.status(500).json({
        status: 0,
        err: error,
      });
    }
  },
  getBundleTypes: (req, res,) => {
    var oldSend = res.send;

    res.send = function(response){
      add_log(req.body, response)
      oldSend.apply(res, arguments);
    }

    try {
      get_bundle_types((err, results) => {

        if (err) {
            
          if (err == 1) {
            return res.status(404).json({
              status: 0,
              message: "No results found",
            });
          }
          return res.status(500).json({
            status: 0,
            err: err,
          });
        }
        return res.status(200).json({
          status: 1,
          data: results,
        });
      });
    } catch (error) {
      return res.status(500).json({
        status: 0,
        err: error,
      });
    }
  },
};
