const connect_pool = require("./config/database");
const https = require('https');
const mysql = require('mysql2/promise');
const db_conn = {
  port:process.env.DB_PORT,
  host:process.env.DB_HOST,
  user:process.env.DB_USER,
  password:process.env.DB_PASSWORD,
  database:process.env.DB_NAME
}
require("dotenv").config({ path: "../.env" });
function discountService(orderData,response){
  
  let typesList = [];
  let dateTime = new Date();
  let date = dateTime.getDate();
  let month = dateTime.getMonth() + 1;
  let bundle_quantity = 0;
  let bundle_value = 0;
  let openbox_quantity = 0;
  let openbox_value = 0;
  if (date < 10) {
    date = "0" + date;
  }

  if (month < 10) {
    month = "0" + month;
  }

  for (const item of orderData) {
    if(item.bundleType == ""){
      typesList.push("ALL");
    } else{
      typesList.push(item.bundleType);
    }
  }
  var currentDate = dateTime.getFullYear() + "-" + month + "-" + date;
  let check_sql = "SELECT discount_criteria FROM tbl_dealerapp_discount_rules WHERE bundle_type IN ? AND status = ? AND DATE(start_date) <= ? AND DATE(end_date) >= ? ORDER BY discount_rule_id DESC LIMIT 1";
  for (const item of orderData) {
    
    let saleType = item.saleType;
    if (saleType == "bundle") {
      bundle_quantity += item.quantity;
      bundle_value += item.amount;
    } else if(saleType == "openbox") {
      openbox_quantity += item.quantity;
      openbox_value += item.amount;
    }
  }
  
try{
  connect_pool.query(
    check_sql,
      [[typesList], "ACTIVE", currentDate, currentDate],
      (error, discountData) => {
        if (error) {
          let message = {
            status : 0, 
            message : error
          }
          return response(message);
        }
        if(discountData.length < 1){
          var bndlGrossAmount = 0;
          var openboxGrossAmount = 0;
          for (const element of orderData) {
            let saleType = element.saleType;
            if (saleType == "bundle") {
              bndlGrossAmount += element.amount;
              
            } else if(saleType == "openbox") {
              openboxGrossAmount += element.amount;
              
            }
          }
          var totalAmount = bndlGrossAmount + openboxGrossAmount;
          var message = {
              totalAmount: totalAmount.toFixed(2),
              payableAmount: totalAmount.toFixed(2),
              bundleDcAmount: 0,
              openboxDcAmount: 0,
              totalDcAmount: 0
            };
            return response({status : 1, data : message});
        }
        if(discountData.length > 0){
          var resultset_data = discountData[0]
          var discpunt_criteria = resultset_data.discount_criteria;
          
          if(discpunt_criteria == "quantity"){
            var check_point = bundle_quantity;
            var sql = "SELECT category,bundle_type,discount_criteria,discount_type,min_invoice_amount,min_quantity,discount_percent,discount_amount,maximum_discount_amount FROM tbl_dealerapp_discount_rules WHERE min_quantity <= ? AND bundle_type IN ? AND status = ? AND DATE(start_date) <= ? AND DATE(end_date) >= ? ORDER BY discount_rule_id DESC LIMIT 1";
          } else{
            var sql = "SELECT category,bundle_type,discount_criteria,discount_type,min_invoice_amount,min_quantity,discount_percent,discount_amount,maximum_discount_amount FROM tbl_dealerapp_discount_rules WHERE min_invoice_amount <= ? AND bundle_type IN ? AND status = ? AND DATE(start_date) <= ? AND DATE(end_date) >= ? ORDER BY discount_rule_id DESC LIMIT 1";
            var check_point = bundle_value;
          }
          try {
            var currentDate = dateTime.getFullYear() + "-" + month + "-" + date;
            var sql_query = connect_pool.query(
              sql,
              [check_point,[typesList], "ACTIVE", currentDate, currentDate],
              (error, resultset) => {
                let grossAmount = 0;
                let bndlGrossAmount = 0;
                let bndlTotalQty = 0;
                let openboxtotalQty = 0;
                let openboxGrossAmount = 0;
                let bndlDcAmount = 0;
                let openboxDcAmount = 0;
                let totalDcAmount = 0;
                let netAmount = 0;
                //console.log(sql_query.sql)
                if (error) {
                  let message = {
                    status : 0, 
                    message : error
                  }
                  return response(message);
                }
                
                for (const element of orderData) {
                  let saleType = element.saleType;
                  if (saleType == "bundle") {
                    bndlGrossAmount += element.amount;
                    bndlTotalQty += element.quantity;
                  } else if(saleType == "openbox") {
                    openboxGrossAmount += element.amount;
                    openboxtotalQty += element.quantity;
                  }
                }
        
                for (const row of resultset) {
                  let criteria = row.discount_criteria;
                  let category = row.category;
                  let minInvoiceVal = row.min_invoice_amount;
                  let minInvoiceQnty = row.min_quantity;
                  let dcType = row.discount_type;
                  let dcPercent = row.discount_percent;
                  let dcAmount = row.discount_amount;
                  let maxDcAmount = row.maximum_discount_amount;
                  let percentVal = 0;
                  let actual_percent = (100 + dcPercent);
                  if (category == "bundle" && ((criteria == "value" && bndlGrossAmount >= minInvoiceVal) || (criteria == "quantity" && bndlTotalQty >= minInvoiceQnty))) {
                    if (dcType == "amount") {
                      bndlDcAmount += dcAmount;
                    }
        
                    if (dcType == "percent") {
                      //percentVal = (bndlGrossAmount * dcPercent) / actual_percent;
                      percentVal = (bndlGrossAmount * dcPercent) / 100;
                      if (percentVal > maxDcAmount && maxDcAmount != 0) {
                        bndlDcAmount += maxDcAmount;
                      } else {
                        bndlDcAmount += percentVal;
                      }
                    }
                  }
        
                  if (category == "openbox" && ((criteria == "value" && openboxGrossAmount >= minInvoiceVal) || (criteria == "quantity" && openboxtotalQty >= minInvoiceQnty))) {
                    if (dcType == "amount") {
                      openboxDcAmount += dcAmount;
                    }
        
                    if (dcType == "percent") {
                      //percentVal = (openboxGrossAmount * dcPercent) / actual_percent;
                      percentVal = (openboxGrossAmount * dcPercent) / 100;
                      if (percentVal > maxDcAmount && maxDcAmount != 0) {
                        openboxDcAmount += maxDcAmount;
                      } else {
                        openboxDcAmount += percentVal;
                      }
                    }
                  }
                }
        
                grossAmount = bndlGrossAmount + openboxGrossAmount;
                totalDcAmount = bndlDcAmount + openboxDcAmount;
                netAmount = grossAmount - totalDcAmount;
        
                const message = {
                  totalAmount: grossAmount.toFixed(2),
                  payableAmount: netAmount.toFixed(2),
                  bundleDcAmount: bndlDcAmount.toFixed(2),
                  openboxDcAmount: openboxDcAmount.toFixed(2),
                  totalDcAmount: totalDcAmount.toFixed(2)
                };
                return response({status : 1, data : message});
              }
            );
          } catch (e) {
            let message = {
              status : 0,
              message : e
            }
            return response(message);
          }


        }
        
    })
  } catch(er){
    let message = {
      status : 0,
      message : er
    }
    return response(message);
  }

}
async function salesDispatchService(data, callBack){

  var orderId = data.salesorder_id;
  var qr = "INSERT INTO tbl_dealer_order_dispatch_address (vendor_id,salesorder_id,dispatch_address,city,state,pincode) VALUES (?,?,?,?,?,?)";
  const connection = await mysql.createConnection(db_conn);
  await connection.beginTransaction();
  try {
    
    for (var i = 0; i < orderId.length; i += 1) {
      var qr1_res = await new Promise((res, rej) => {
        connect_pool.query(qr, [data.vendor_id, orderId[i], data.dispatch_address, data.city, data.state, data.pincode],
          (result1_err, results_1) => {
            
              if (result1_err){
                connection.rollback();
                return callBack(result1_err);
              } 
              res(results_1);
        });
      });
      
      if(qr1_res.insertId == null || qr1_res.insertId == ''){

        let res1_obj = {
          "status" : 0,
          "message" : "Dispatch address not added"
        }
        return callBack(null, res1_obj)
      }
    }
    await connection.commit();
    await connection.end();
    let res2_obj = {
      "status" : 1,
      "message" : "Your have added dispatch address successfully"
    }
    return callBack(res2_obj)
  } catch (e) {
      await connection.rollback()
      connection.releaseConnection()
      return callBack(e);
  }
}
async function ssDispatchAddressService(data, callBack){

  var orderId = data.salesorder_id;
  var qr = "INSERT INTO tbl_ss_dealer_order_dispatch_address (vendor_id,salesorder_id,dispatch_address,city,state,pincode) VALUES (?,?,?,?,?,?)";
  const connection = await mysql.createConnection(db_conn);
  await connection.beginTransaction();
  try {
    
    for (var i = 0; i < orderId.length; i += 1) {
      var qr1_res = await new Promise((res, rej) => {
        connect_pool.query(qr, [data.vendor_id, orderId[i], data.dispatch_address, data.city, data.state, data.pincode],
          (result1_err, results_1) => {
            
              if (result1_err){
                connection.rollback();
                return callBack(result1_err);
              } 
              res(results_1);
        });
      });
      
      if(qr1_res.insertId == null || qr1_res.insertId == ''){

        let res1_obj = {
          "status" : 0,
          "message" : "Dispatch address not added"
        }
        return callBack(null, res1_obj)
      }
    }
    await connection.commit();
    await connection.end();
    let res2_obj = {
      "status" : 1,
      "message" : "Your have added dispatch address successfully"
    }
    return callBack(res2_obj)
  } catch (e) {
      await connection.rollback()
      connection.releaseConnection()
      return callBack(e);
  }
}

function deleteShippingAddressService(data, response){

  if(data.attached_vendor_id == '' || data.category_id == 2){
    var qr = "DELETE from tbl_dealer_shipping_address WHERE shipping_id = ?";
  } else{
    var qr = "DELETE from tbl_ss_dealer_shipping_address WHERE shipping_id = ?";
  }
  try {
    connect_pool.query(
      qr,[data.shipping_id],(error, results) => {
        if (error) {
          let res_obj = {
            status : 0,
            message : error
          }
          return response(res_obj);
        }

        if (results.affectedRows < 1) {
          let res_obj = {
            status : 0,
            message : "No item deleted"
          }
          return response(res_obj);
        }
        let res_obj = {
          status : 1,
          message : "Deleted successfully"
        }
        return response(res_obj);
      }
    );
  } catch (e) {
    let res_obj = {
      status : 0,
      message : e
    }
    return response(res_obj);
  }
}

function updateShippingAddressService(data, response){

  if(data.state == 'Chattisgarh'){
    data.state = 'Chhattisgarh';
  }
  var qr1 = "SELECT state_id FROM tbl_states WHERE name = ?";
  if(data.attached_vendor_id == '' || data.category_id == 2){
    var qr2 = "UPDATE tbl_dealer_shipping_address SET shipping_address = ?, state = ?, city = ?, pincode = ? WHERE shipping_id = ?";
  } else{
    var qr2 = "UPDATE tbl_ss_dealer_shipping_address SET shipping_address = ?, state = ?, city = ?, pincode = ? WHERE shipping_id = ?";
  }
  try {
    connect_pool.query(
      qr1,[data.state],(state_err, stateData) => {

        if (state_err) {
          return callBack({status:0, message:state_err});
        }

        if (stateData.length < 1) {
          let err_state = "State does not exist";
          return callBack({status:0, message:err_state});
        }
        var state_id = stateData[0].state_id;
        try {
          connect_pool.query(
            qr2,[data.shipping_address,state_id,data.city,data.pincode,data.shipping_id],
            (update_err, result) => {
              if (update_err) {
                var res_obj = {
                  status : 0,
                  message : update_err 
                }
                return response(res_obj);
              }
              var res_obj = {
                status : 1,
                message : result 
              }
              return response(res_obj);
            }
          );
        } catch (e) {
          var res_obj = {
            status : 0,
            message : e 
          }
          return response(res_obj);
        }
      })
    } catch(e){
      var res_obj = {
        status : 0,
        message : e 
      }
      return response(res_obj);
    }
  
}

function getShippingAddressService(data, response){
  if (data.vendor_id == "" || data.vendor_id == undefined) {
    var res_obj = {
      status : 0,
      message : "No results found"
    }
    return response(res_obj);
  }
  if(data.attached_vendor_id == '' || data.category_id == 2){
    var qr1 = "SELECT * from tbl_dealer_shipping_address WHERE vendor_id = ?";
  } else{
    var qr1 = "SELECT * from tbl_ss_dealer_shipping_address WHERE vendor_id = ?";
  }
  try {
    connect_pool.query(qr1,[data.vendor_id],
      (row_error, rows) => {
        if (row_error) {
          var res_obj = {
            status : 0,
            message : row_error
          }
          return response(res_obj);
        }

        if (rows.length < 1) {
          var res_obj = {
            status : 0,
            message : "No results found"
          }
          return response(res_obj);
        }
        const result_arr = [];

        rows.forEach((row_data) => {
          var state_id = row_data.state
          try {
            connect_pool.query(
              `SELECT name from tbl_states WHERE state_id = ?`,
              [state_id],
              (state_err, state_data) => {
                if (state_err) {
                  return response({status:0, message:state_err});
                }
                
                if (state_data[0].name == undefined || state_data[0].name == "undefined") {
                  return callBack("State not available");
                }
                result_obj = {
                  shipping_id: row_data.shipping_id,
                  shipping_address: row_data.shipping_address,
                  state: state_data[0].name,
                  city: row_data.city,
                  pincode: row_data.pincode,
                  created_date: row_data.created_date,
                  updated_date: row_data.updated_date,
                };
                result_arr.push(result_obj);
                
                if (result_arr.length == rows.length) {
                  var res_obj = {
                    status : 1,
                    data : result_arr
                  }
                  return response(res_obj);
                }
                
              }
            );
          } catch (e) {
            return callBack(e);
          }
        });
      }
    );
  } catch (e) {
    var res_obj = {
      status : 0,
      data : e
    }
    return response(res_obj);
  }
}

async function addShippingAddressService(data, callBack){

  if(data.state == 'Chattisgarh'){
    data.state = 'Chhattisgarh';
  }
  const connection = await mysql.createConnection(db_conn);
  await connection.beginTransaction();
  var qr1 = "SELECT state_id FROM tbl_states WHERE name = ?";
  if(data.attached_vendor_id == '' || data.category_id == 2){
    var qr2 = "INSERT into tbl_dealer_shipping_address (vendor_id,shipping_address,state,city,pincode) VALUES (?,?,?,?,?)";
  } else{
    var qr2 = "INSERT into tbl_ss_dealer_shipping_address (vendor_id,shipping_address,state,city,pincode) VALUES (?,?,?,?,?)";
  }
  try {

    var qr1_res = await new Promise((res, rej) => {
    connect_pool.query(qr1,data.state,(row1_err, row1) => {
        
            if (row1_err){
              connection.rollback(); return callBack(row1_err);
            }
            res(row1);
        });
    });

    if (qr1_res.length < 1) {
      let res1_obj = {
        "status" : 0,
        "message" : "State does not exist"
      }
      return callBack(res1_obj)
    }
    var state_id = qr1_res[0].state_id;
    var qr2_res = await new Promise((res, rej) => {
      connect_pool.query(qr2,[data.vendor_id, data.shipping_address, state_id,data.city,data.pincode],
        (result1_err, results_1) => {
          
            if (result1_err){
              connection.rollback();
              return callBack(result1_err);
            } 
            res(results_1);
      });
    });
    if(qr2_res.insertId == null || qr2_res.insertId == ''){

      let res1_obj = {
        "status" : 0,
        "message" : "Shipping address not created"
      }
      return callBack(res1_obj)
    }
    let res1_obj = {
      "status" : 1,
      "message" : "Shipping Address created successfully"
    }
    await connection.commit();
    await connection.end();
    return callBack(res1_obj)
  }
  catch (err) {
    await connection.rollback()
    connection.releaseConnection()
    return callBack(err);
  }
}
async function deleteCartItemService(body, response){
    
  if (
    body.vendor_id == "" || body.vendor_id == undefined || body.bundle_id == "" || body.bundle_id == undefined) {
    var res_obj = {
      status: 0,
      message: "Please Provide vendor id, SKU and stock type",
    }
    return response(res_obj);
  }
  var qr1 = "DELETE from tbl_dealer_cart WHERE vendor_id = ? AND bundle_id = ?";
  const connection = await mysql.createConnection(db_conn);
  await connection.beginTransaction();
  
  try {
      
    var qr1_res = await new Promise((res, rej) => {
      connect_pool.query(qr1, [body.vendor_id, body.bundle_id],
        (result1_err, results_1) => {
          
            if (result1_err){
              connection.rollback();
              return callBack({status: 0,message: result1_err});
            } 
            res(results_1);
      });
    });
    if (qr1_res.affectedRows < 1) {
      var res_obj = {
        status: 0,
        message: "Not deleted cart item"
      }
      return response(res_obj);
    }
    await connection.commit()
    await connection.end()
    var res_obj = {
      status: 1,
      message: "Cart item deleted successfully"
    }
    return response(res_obj);
  }
  catch (err) {
    await connection.rollback()
    connection.releaseConnection()
    var res_obj = {
      status: 0,
      message: err
    }
    return callBack(res_obj);
  }
}
function getCartItemsService(vendor_id, callBack){
  if (vendor_id == "") {
    return callBack({status : 0, message: "Please provide vendor"});
  }

  try {
    connect_pool.query(
      `select * from tbl_dealer_cart WHERE vendor_id = ?`,
      [vendor_id],
      (err, result) => {
        if (err) {
          return callBack({status : 0, message: err});
        }

        if (result.length == 0) {
          let err_list = "No results found";
          return callBack({status : 0, message: err_list});
        }
        var cart = [];

        result.forEach((element) => {
          let bundle_id = element.bundle_id;
          let sale_type = element.sale_type;

          if (sale_type == "BUNDLE") {
            try {
              connect_pool.query(
                `SELECT * from tbl_dealer_bundle WHERE bundle_id = ?`,
                [bundle_id],
                (row_err, row) => {
                  if (row_err) {
                    return callBack({status : 0, message: row_err});
                  }

                  if (row.length < 1) {
                    let err_bundle = row[0].bunlde_no + "is not availble ";
                    return callBack({status : 0, message: err_bundle});
                  }
                  var grade_qnty = "";
                  var bundle_type = row[0].type;

                  if (bundle_type == "1A") {
                    grade_qnty = "SG-A(5) SG-B(5)";
                  } else if (bundle_type == "1B") {
                    grade_qnty = "SG-A(4) SG-B(6)";
                  } else if (bundle_type == "1C") {
                    grade_qnty = "SG-A(2) SG-B(3) SG-C(5)";
                  } else if (bundle_type == "1D") {
                    grade_qnty = "SG-D(10)";
                  } else if (bundle_type == "1E") {
                    grade_qnty = "SG-B(3) SG-C(7)";
                  } else if (bundle_type == "1F") {
                    grade_qnty = "SG-B(3) SG-C(5) SG-D(2)";
                  } else if (
                    bundle_type == "2A" || bundle_type == "2B" || bundle_type == "2C" || bundle_type == "2D" || bundle_type == "2E" || bundle_type == "2F") {
                    grade_qnty = "SG-A(3) SG-B(3) SG-B(4)";
                  }
                  result_obj = {
                    bundle_id: row[0].bundle_id,
                    bundle_no: row[0].bundle_no,
                    type: row[0].type,
                    grade_qnty: grade_qnty,
                    category: row[0].category,
                    sub_category: row[0].sub_category,
                    quantity: row[0].quantity,
                    amount: row[0].amount,
                    mop: row[0].mop,
                    status: element.status,
                    updated_date: element.updated_date,
                  };
                  cart.push(result_obj);

                  if (cart.length == result.length) {
                    return callBack({status:1, data:cart});
                  }
                }
              );
            } catch (e) {
              return callBack({status:0, message:e});
            }
          } else if (sale_type == "OPEN BOX" || sale_type == "PREXO") {
            try {
              connect_pool.query(
                `SELECT grnreport_id, nhdin, nhmod, certification_grade,device_name, device_sub_category,color,SKU,mrp,product_brand, ram,rom,stock_type from tbl_grnreport WHERE grnreport_id = ?`,
                [bundle_id],
                (err, row) => {
                  if (err) {
                    return callBack({status:0, message:err});
                  }

                  if (row.length < 1) {
                    let err_bundle = row[0].nhdin + "is not availble ";
                    return callBack({status:0, message:err_bundle});
                  }
                  var server_path = process.env.IMAGE_URL;
                  var image_name = row[0].nhmod + '.jpg';
                  var actual_image_url = server_path + image_name;
                  var default_image_url = server_path + "default.jpg";
                  var image_path = ''
                  https.get(actual_image_url,function(res){
                    if(res.statusCode == 200){
                      image_path = actual_image_url;
                    } else {
                      image_path = default_image_url;
                    }
                    result_obj = {
                      grnreport_id: row[0].grnreport_id,
                      device_id: row[0].nhdin,
                      certification_grade: row[0].certification_grade,
                      device_name: row[0].device_name,
                      device_sub_category: row[0].device_sub_category,
                      color: row[0].color,
                      SKU: row[0].SKU,
                      mrp: row[0].mrp,
                      amount:row[0].mrp,
                      product_brand: row[0].product_brand,
                      ram: row[0].ram,
                      rom: row[0].rom,
                      stock_type: row[0].stock_type,
                      image_path: image_path
                    };
                    cart.push(result_obj);
  
                    if (cart.length == result.length) {
                      return callBack({status: 1, data:cart});
                    }
                  });
                }
              );
            } catch (e) {
              return callBack({staus:0, message:e});
            }
          }
        });
      }
    );
  } catch (e) {
    return callBack({staus:0, message:e});
  }
}

async function addToCartService(data, callBack){
    
  var vendor_id = data.vendor_id;
  var bundle_id = data.bundle_id;
  var sale_type = data.sale_type;

  if (vendor_id == "" || vendor_id == undefined) {
    let err_vendor = "Please provide vendor id";
    return callBack({status:0, message:err_vendor});
  }

  if (bundle_id == "" || bundle_id == undefined) {
    let err_bndl = "Please select bundle";
    return callBack({status:0, message:err_bndl});
  }

  if (sale_type == "" || sale_type == undefined) {
    let err_type = "Please add sale type";
    return callBack({status:0, message:err_type});
  }
  if (sale_type == "BUNDLE") {
    var qr1 = "SELECT status from tbl_dealer_bundle WHERE bundle_id = ?";
  } else{
    var qr1 = "SELECT status from tbl_grnreport WHERE grnreport_id = ?";
  }
  var qr2 = "SELECT * from tbl_dealer_cart WHERE bundle_id = ? AND vendor_id = ?";
  var qr3 = "INSERT into tbl_dealer_cart (vendor_id,bundle_id,sale_type) VALUES (?,?,?)";
  const connection = await mysql.createConnection(db_conn);
  await connection.beginTransaction();
  
  try {
    
    var qr1_res = await new Promise((res, rej) => {
      connect_pool.query(qr1, bundle_id,
        (result1_err, results_1) => {
          
            if (result1_err){
              connection.rollback();
              return callBack({status:0, message:results_1});
            } 
            res(results_1);
      });
    });
    if (qr1_res.length < 1) {
      let err_msg = "Not available";
      return callBack({status:0, message:err_msg});
    }
    if(data.category_id == 2 || data.attached_vendor_id == null || data.attached_vendor_id == ""){
      if (sale_type == "BUNDLE") {

        if (qr1_res[0].status != "ACTIVE") {
          let err_add = "Not available in-stock";
          return callBack({status:0, message:err_add});
        }
      } else{
        if (qr1_res[0].status != "RFS") {
          let err_add = "Not available in-stock";
          return callBack({status:0, message:err_add});
        }
      }
    }
    var qr2_res = await new Promise((res, rej) => {
      connect_pool.query(qr2, [bundle_id, vendor_id],
        (result2_err, results_2) => {
          console.log(results_2)
            if (result2_err){
              connection.rollback();
              return callBack({status:0, message:result2_err});
            } 
            res(results_2);
      });
    });
    if (qr2_res.length > 0) {
      let err_cart = "Item already in the cart";
      return callBack({status:0, message:err_cart});
    }
    var qr3_res = await new Promise((res, rej) => {
      connect_pool.query(qr3, [vendor_id, bundle_id, sale_type],
        (result3_err, results_3) => {
            if (result3_err){
              connection.rollback();
              return callBack({status:0, message:result3_err});
            } 
            res(results_3);
      });
    });
    await connection.commit()
    await connection.end()
    let msg ='Added to cart successfully'
    return callBack({status:1, message:msg});
  }
  catch (err) {
    await connection.rollback()
    connection.releaseConnection()
    return callBack({status:0, message:err});
  }
}
function tcsService(data, response){
   
   if((data.category_id == 3 || data.category_id == 4) && data.attached_vendor_id != ""){
      var qr = "SELECT sum(amount) as amount FROM DEALERAPP_CUSTOMER_TCS_VALUE_VIEW WHERE vendor_id = ?";
   } else{
      var qr = "SELECT sum(amount) as amount FROM CUSTOMER_TCS_VALUE_VIEW WHERE vendor_id = ?";
   }
   try {
     connect_pool.query(
      qr,[data.vendorId],(tcs_err, total_amount) => {

        if (tcs_err) {
          return response({status : 0, message : tcs_err});
        }
        var order_amount = data.orderAmount;
        var total_amount = total_amount[0].amount;
        var check_amount = 5000000;
        if (total_amount <= check_amount) {
          var final_amount = total_amount + order_amount;

          if (final_amount >= check_amount) {
            var tcs_percent = 0.1;
            let actual_amount = final_amount - check_amount;
            var tcs_value = (tcs_percent * actual_amount) / 100;
          } else {
            var tcs_percent = 0;
            var tcs_value = 0;
          }

        } else {
          var tcs_percent = 0.1;
          //var tcs_value = (tcs_percent * 100) / bundle_amount;
          var tcs_value = (tcs_percent * order_amount) / 100;
        }
        return response({status : 1, tcs_value : tcs_value});
      }
     );
   } catch (e) {
     return response({status : 0, message : e});
   }
 }

function logService(request, response){
  var req = JSON.stringify(request);

  try {
    connect_pool.query(
      `INSERT into tbl_dealer_error_log(request,response) VALUES(?,?)`,
      [req,response]
    );
  } catch (e) {}
}
async function ssDiscountService(body, response){

  var category_id = body.category_id;
  var orderData = body.orderData;
  var bndlGrossAmount = 0;
  for (const element of orderData) {
    
    bndlGrossAmount += element.amount;
  }
  if(category_id == 2 || category_id == 3){
    var qr1 = "SELECT margin_percent as discount_percent FROM tbl_dealer_role_category WHERE category_id = ?";
  } else{
    var qr1 = "SELECT discount_percent FROM tbl_dealer_role_category WHERE category_id = ?";
  }
  const connection = await mysql.createConnection(db_conn);
  await connection.beginTransaction();
  try {
    var qr1_res = await new Promise((res, rej) => {
    connect_pool.query(qr1, [category_id],
      (result1_err, results_1) => {
        
          if (result1_err){
            connection.rollback();
            return callBack(result1_err);
          } 
          res(results_1);
      });
    });
    var dis_percent = qr1_res[0].discount_percent;
    var actual_dis = (100 + dis_percent);
    var payble_amount = (bndlGrossAmount * 100) / actual_dis;
    var dis_amount = parseFloat(bndlGrossAmount) - parseFloat(payble_amount)
    
    await connection.commit();
    await connection.end();
    var message = {
      totalAmount: bndlGrossAmount.toFixed(2),
      payableAmount: payble_amount.toFixed(2),
      bundleDcAmount: parseFloat(dis_amount).toFixed(2),
      openboxDcAmount: 0,
      totalDcAmount: parseFloat(dis_amount).toFixed(2),
      discount_percent : dis_percent
    };
    return response({status : 1, data : message});
  } catch (e) {
      await connection.rollback()
      connection.releaseConnection()
      return callBack(e);
  }
}

async function clearCartListService(vendor_id, callBack){

  var qr = "DELETE FROM tbl_dealer_cart WHERE vendor_id = ?";
  const connection = await mysql.createConnection(db_conn);
  await connection.beginTransaction();
  try {
    

    var qr1_res = await new Promise((res, rej) => {
      connect_pool.query(qr, vendor_id,
        (result1_err, results_1) => {
          
            if (result1_err){
              connection.rollback();
              return callBack({status : 0, message : result1_err});
            } 
            res(results_1);
      });
    });
    
    if(qr1_res.length < 1){
      return callBack({status : 0, message : "No cart items found"});
    }
    
    await connection.commit();
    await connection.end();
    let res2_obj = {
      "status" : 1,
      "message" : "Your have cleared cart successfully"
    }
    return callBack({status : 1, message : "Your have cleared cart successfully"})
  } catch (e) {
      await connection.rollback()
      connection.releaseConnection()
      return callBack(e);
  }
}
module.exports = {
  logService,
  addToCartService,
  getCartItemsService,
  deleteCartItemService,
  addShippingAddressService,
  getShippingAddressService,
  updateShippingAddressService,
  deleteShippingAddressService,
  salesDispatchService,
  discountService,
  tcsService,
  ssDispatchAddressService,
  ssDiscountService,
  clearCartListService
};
