const {
  addToCartService,
  logService,
  deleteCartItemService,
  getCartItemsService,
  addShippingAddressService,
  getShippingAddressService,
  updateShippingAddressService,
  deleteShippingAddressService,
  salesDispatchService,
  discountService,
  tcsService,
  ssDispatchAddressService,
  ssDiscountService,
  clearCartListService
} = require("./cart-service");

function addToCart (req, res)  {
  const body = req.body;

  var oldSend = res.send;
  res.send = function(response){
    logService(body, response)
    oldSend.apply(res, arguments);
  }

  addToCartService(body, (result) => {
    return res.json(result);
  });
}

function addShippingAddress(req, res){
  const body = req.body;
  var oldSend = res.send;

  res.send = function(response){
    logService(body, response)
    oldSend.apply(res, arguments);
  }

  if (body.vendor_id == "" || body.vendor_id == undefined) {
    return res.status(200).json({
      status: 0,
      message: "Please provide vendor id",
    });
  }

  if (body.state == "" || body.state == undefined) {
    return res.status(200).json({
      status: 0,
      message: "Please provide state",
    });
  }

  if (body.city == "" || body.city == undefined) {
    return res.status(200).json({
      status: 0,
      message: "Please provide city",
    });
  }

  if (body.shipping_address == "" || body.shipping_address == undefined) {
    return res.status(200).json({
      status: 0,
      message: "Please provide shipping address",
    });
  }

  if (body.pincode == "" || body.pincode == undefined) {
    return res.status(200).json({
      status: 0,
      message: "Please provide pincode",
    });
  }

  addShippingAddressService(body, (result) => {
    return res.json(result);
  });
  
}

function cartList (req, res) {
  var vendor_id = req.params.vendor_id;
  var oldSend = res.send;

  res.send = function(response){
    logService(req.params, response)
    oldSend.apply(res, arguments);
  }
  
  getCartItemsService(vendor_id, (result) => {
    return res.json(result);
  });
}

function getShippingAddress(req, res){
  var data = req.body;
  var oldSend = res.send;

  res.send = function(response){
    logService(req.params, response)
    oldSend.apply(res, arguments);
  }

  getShippingAddressService(data, (result) => {
    return res.json(result);
  });
}

function deleteCartItem(req, res){
  var body = req.body;
  var oldSend = res.send;

  res.send = function(response){
    logService(body, response)
    oldSend.apply(res, arguments);
  }

  deleteCartItemService(body, (result) => {
    return res.json(result);
  });
}

function updateShippingAddress(req, res){
  const body = req.body;
  var oldSend = res.send;

  res.send = function(response){
    logService(body, response)
    oldSend.apply(res, arguments);
  }
  
  if (body.shipping_id == "" || body.shipping_id == undefined) {
    return res.status(200).json({
      status: 0,
      message: "Please provide shipping id",
    });
  }

  if (body.state == "" || body.state == undefined) {
    return res.status(200).json({
      status: 0,
      message: "Please provide state",
    });
  }

  if (body.city == "" || body.city == undefined) {
    return res.status(200).json({
      status: 0,
      message: "Please provide city",
    });
  }

  if (body.shipping_address == "" || body.shipping_address == undefined) {
    return res.status(200).json({
      status: 0,
      message: "Please provide shipping address",
    });
  }

  if (body.pincode == "" || body.pincode == undefined) {
    return res.status(200).json({
      status: 0,
      message: "Please provide pincode",
    });
  }
  updateShippingAddressService(body, (result) => {
    return res.json(result);
  });
  
}
function deleteShippingAddress(req, res) {
  var body = req.body;
  var oldSend = res.send;

  res.send = function(response){
    logService(body, response)
    oldSend.apply(res, arguments);
  }

  if(body.shipping_id == '' || body.shipping_id == undefined ){
    return res.status(200).json({
      status: 0,
      message: "Please Provide shipping id",
    });
  }
  deleteShippingAddressService(body, (result) => {
    return res.json(result);
  });
  
}
function salesDispatch (req, res){
  var body = req.body;
  var oldSend = res.send;

  res.send = function(response){
    logService(body, response)
    oldSend.apply(res, arguments);
  }

  if(body.vendor_id == '' || body.vendor_id == undefined ){
    return res.status(200).json({
      status: 0,
      message: "Please Provide vendor id",
    });
  }
  var salesorder = body.salesorder_id;

  if(salesorder.length == 0){
    return res.status(200).json({
      status: 0,
      message: "Please Provide salesorder id",
    });
  }

  if(body.state == '' || body.state == undefined ){
    return res.status(200).json({
      status: 0,
      message: "Please Provide state",
    });
  }

  if(body.city == '' || body.city == undefined ){
    return res.status(200).json({
      status: 0,
      message: "Please Provide city",
    });
  }

  if(body.dispatch_address == '' || body.dispatch_address == undefined ){
    return res.status(200).json({
      status: 0,
      message: "Please Provide address",
    });
  }
  salesDispatchService(body, (result) => {
    return res.json(result);
  });
}

function discount (req, res) {
  var body = req.body;
  var oldSend = res.send;

  res.send = function(response){
    logService(body, response)
    oldSend.apply(res, arguments);
  }
  var order_data = body.orderData;

  if(order_data.length < 1){

    return res.status(200).json({
      status: 0,
      message: "Something went wrong",
    });

  }
  discountService(order_data, (result) => {
    return res.json(result);
  });
}
function getTcsValue (req, res) {
  var body = req.body;
  var oldSend = res.send;

  res.send = function(response){
    logService(body, response)
    oldSend.apply(res, arguments);
  }
  var vendorId = body.vendorId;

  if(vendorId == '' || vendorId == undefined){

    return res.status(200).json({
      status: 0,
      message: "Provide vendor",
    });

  }
  tcsService(body, (result) => {
    return res.json(result);
  });
}
function ssDispatchAddress (req, res){
  var body = req.body;
  var oldSend = res.send;

  res.send = function(response){
    logService(body, response)
    oldSend.apply(res, arguments);
  }

  if(body.vendor_id == '' || body.vendor_id == undefined ){
    return res.status(200).json({
      status: 0,
      message: "Please Provide vendor id",
    });
  }
  var salesorder = body.salesorder_id;

  if(salesorder.length == 0){
    return res.status(200).json({
      status: 0,
      message: "Please Provide salesorder id",
    });
  }

  if(body.state == '' || body.state == undefined ){
    return res.status(200).json({
      status: 0,
      message: "Please Provide state",
    });
  }

  if(body.city == '' || body.city == undefined ){
    return res.status(200).json({
      status: 0,
      message: "Please Provide city",
    });
  }

  if(body.dispatch_address == '' || body.dispatch_address == undefined ){
    return res.status(200).json({
      status: 0,
      message: "Please Provide address",
    });
  }
  ssDispatchAddressService(body, (result) => {
    return res.json(result);
  });
}
function ssDiscount (req, res) {
  var body = req.body;
  var oldSend = res.send;

  res.send = function(response){
    logService(body, response)
    oldSend.apply(res, arguments);
  }
  var order_data = body.orderData;

  if(order_data.length < 1){

    return res.status(200).json({
      status: 0,
      message: "Something went wrong",
    });

  }
  ssDiscountService(body, (result) => {
    return res.json(result);
  });
}
function clearCartList (req, res) {
  var vendor_id = req.params.vendor_id;
  var oldSend = res.send;

  res.send = function(response){
    logService(vendor_id, response)
    oldSend.apply(res, arguments);
  }
  clearCartListService(vendor_id, (result) => {
    return res.json(result);
  });
}

module.exports = {
  addToCart,
  cartList,
  deleteCartItem,
  addShippingAddress,
  getShippingAddress,
  updateShippingAddress,
  deleteShippingAddress,
  salesDispatch,
  discount,
  getTcsValue,
  ssDispatchAddress,
  ssDiscount,
  clearCartList

}


